<?php
/**
 * The off-canvas menu uses the Off-Canvas Component
 *
 * For more info: http://jointswp.com/docs/off-canvas-menu/
 */
?>

<div class="top-bar" id="top-bar-menu">
  <div class="grid-container">
    <div class="grid-x grid-margin-x grid-padding-x">
      <div class="small-12 medium-12 large-12 cell">        
        <div class="top-bar-left float-left">
          <?php
            $custom_logo_id = get_theme_mod( 'custom_logo' );
            $logo = wp_get_attachment_image_src( $custom_logo_id , 'full' ); 
            if ( has_custom_logo() ) {
                echo '<img id="logo" src="' . esc_url( $logo[0] ) . '" alt="' . get_bloginfo( 'name' ) . '">';
            } else {
                echo '<ul class="menu">';
                  echo '<li><a href="' . home_url() . '">' . bloginfo('name') . '</a></li>';
                echo '</ul>';             
            }
          ?>          
        </div>
        <div class="top-bar-right show-for-medium">
          <?php joints_top_nav(); ?>	
        </div>
        <div class="top-bar-right float-right mobile-menu show-for-small-only">
          <div class="mobile-menu-icon">
            <div class="icon-container">
              <div class="menu_icon">
                <span class="one"></span>
                <span class="two"></span>
                <span class="three"></span>
                <label>Menu</label>
              </div>
            </div>
          </div>
          <div id="mobile-menu">
            <?php joints_top_nav(); ?>
          </div> 
        </div>
      </div>
    </div>
  </div>
</div>
<div id="location-heading">
  <div class="grid-container">
    <div class="grid-x grid-margin-x grid-padding-x">
      <div class="small-12 medium-12 large-12 cell"> 
        <div class="location"><?php echo get_field('location_heading', 6); ?></div>
        <?php 
            $date = new DateTime(null, new DateTimeZone('America/New_York')); 
            $localtime = $date->getTimestamp() + $date->getOffset();
          ?>
          <div id="clock" class="show-for-medium" data-startdate="<?php echo $date->getTimestamp() + $date->getOffset();?>" data-end-date=""></div>
          <script>
            // Set the date we're counting down to
            var countDownDate = new Date("Oct 8, 2023 10:00:00").getTime();

            // Update the count down every 1 second
            var x = setInterval(function() {

              // Get today's date and time
              const startdate = '<?=$localtime?>';
              var now = new Date().getTime(startdate * 1000);
                
              // Find the distance between now and the count down date
              var distance = countDownDate - now;
                
              // Time calculations for days, hours, minutes and seconds
              var days = Math.floor(distance / (1000 * 60 * 60 * 24));
              var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
              var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
              var seconds = Math.floor((distance % (1000 * 60)) / 1000);
                
              // Output the result in an element with id="clock"
              document.getElementById("clock").innerHTML = '<div class="clock-header">Countdown to the Valor Cup</div><div id="days">' + days + '<span>days</span></div><div id="hours">' + hours + '<span>hours</span></div><div id="minutes">'
              + minutes + '<span>minutes</span></div><div id="seconds">' + seconds + '<span>seconds</span></div>';
                
              // If the count down is over, write some text 
              if (distance < 0) {
                clearInterval(x);
                document.getElementById("clock-mobile").style.display = 'none';
              }
            }, 1000);
            </script>          
      </div>
    </div>
  </div>
</div>
