<?php 
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 */

get_header(); ?>
	
<div class="homepage-top-wrap" id="hero-section" style="background-image:url(<?php print get_field('top_background_image');?>">
	
  <div class="content grid-container">
	
		<div class="inner-content grid-x grid-margin-x grid-padding-x">
	
		  <main class="main small-12 medium-12 cell" role="main">

			    	<?php //get_template_part( 'parts/loop', 'page' ); 

              print '<h2>' . get_field('hero_area_heading') . '</h2>';
              $link = get_field('top_button_link');
              if( $link ): 
                  $link_url = $link['url'];
                  $link_title = $link['title'];
                  $link_target = $link['target'] ? $link['target'] : '_self';
                  ?>
                  <a class="button" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
            <?php endif; ?>
            <img id="top-sponsor-logo" src="<?php echo get_field('top_sponsor_logo'); ?>">
			</main> <!-- end #main -->
		    
		</div> <!-- end #inner-content -->

	</div> <!-- end #content -->

</div>

<?php 
  $date = new DateTime(null, new DateTimeZone('America/New_York')); 
  $localtime = $date->getTimestamp() + $date->getOffset();
?>
<div id="clock-mobile" class="show-for-small-only" data-startdate="<?php echo $date->getTimestamp() + $date->getOffset();?>" data-end-date=""></div>
<script>
  // Set the date we're counting down to
  var countDownDate = new Date("Sept 30, 2024 10:00:00").getTime();

  // Update the count down every 1 second
  var x = setInterval(function() {

    // Get today's date and time
    const startdate = '<?=$localtime?>';
    var now = new Date().getTime(startdate * 1000);
      
    // Find the distance between now and the count down date
    var distance = countDownDate - now;
      
    // Time calculations for days, hours, minutes and seconds
    var days = Math.floor(distance / (1000 * 60 * 60 * 24));
    var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
    var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
    var seconds = Math.floor((distance % (1000 * 60)) / 1000);
      
    // Output the result in an element with id="clock"
    document.getElementById("clock-mobile").innerHTML = '<div class="clock-header">Countdown to the Valor Cup</div><div id="days">' + days + '<span>days</span></div><div id="hours">' + hours + '<span>hours</span></div><div id="minutes">'
    + minutes + '<span>minutes</span></div><div id="seconds">' + seconds + '<span>seconds</span></div>';
      
    // If the count down is over, write some text 
    if (distance < 0) {
      clearInterval(x);
      document.getElementById("clock-mobile").style.display = 'none';
    }
  }, 1000);
</script>  
<div id="our-story">
  <div class="content grid-container">
    <div class="inner-content grid-x grid-margin-x grid-padding-x">
      <div class="small-12 medium-10 medium-offset-1 cell">
        <?php $ourstory = get_field('our_story');
          if($ourstory) {
            print '<h2>' . $ourstory['our_story_heading'] . '</h2>';
            print '<div class="our-story-copy">' . $ourstory['our_story_copy'] . '</div>';
            if($ourstory['our_story_image']) {
              print '<div class="our-story-image" style="background-image:url(' . $ourstory['our_story_image']['url'] . ';"></div>';
            }
          }
        ?>
      </div>
    </div>  
  </div>
</div> 

<?php 
  $thecourse = get_field('the_course');
  if($thecourse): ?>
    <div id="the-course" style="background-image:url(<?php print $thecourse['the_course_bg']['url']; ?>);">
      <div class="course-overlay"></div>
      <div class="content grid-container">
        <div class="inner-content grid-x grid-margin-x grid-padding-x">
          <div class="small-12 medium-8 medium-offset-2 cell">
            <?php print '<h2>' . $thecourse['the_course_heading'] . '</h2>';?>
            <?php print '<div class="our-story-copy">' . $thecourse['the_course_copy'] . '</div>'; ?>
            <?php $course_link = $thecourse['the_course_link'];
              if($course_link): 
                $course_url = $course_link['url'];
                $course_title = $course_link['title'];
                $course_target = $course_link['target'] ? $course_link['target'] : '_self';
              ?>
                  <a class="button" href="<?php echo esc_url( $course_url ); ?>" target="<?php echo esc_attr( $course_target ); ?>"><?php echo esc_html( $course_title ); ?></a>				
			    	
            <?php endif; ?>            
          </div>
        </div>  
      </div>
    </div> 
<?php
  endif;?>

<div id="how-it-works">
  <div class="grid-container">
    <?php if( have_rows('how_it_works') ): ?>
      <div class="grid-x grid-margin-x">
        <div class="small-12 medium-12 cell">
          <h2>How It Works</h2>
        </div>
        <?php while( have_rows('how_it_works') ): the_row();?>
          <div class="small-12 medium-4 outer-wrap cell">
            <div class="inner-line">
              <div class="inner-icon" style="background-image: url(<?php the_sub_field('how_it_works_icon'); ?>);"></div>
              <h5><?php the_sub_field('how_it_works_heading'); ?></h5>
              <p><?php the_sub_field('how_it_works_copy'); ?></p>
            </div>
          </div>
        <?php endwhile; ?>
      </div>
    <?php endif; ?>
  </div>
  <div class="grid-container">
	<?php if( have_rows('documents') ): ?>
	  <div class="grid-x grid-margin-x">
		<?php while( have_rows('documents') ): the_row();
          $image = get_sub_field('background_image');
          $link = get_sub_field('link');?>
			<div class="small-12 medium-6 document-block cell" style="background-image: url(<?php the_sub_field('background_image'); ?>);">
				<a href="<?php print $link['url']; ?>" target="_blank">
					<h4><?php print $link['title']; ?></h4>
				</a>
			</div>
        <?php endwhile; ?>
      </div>
    <?php endif; ?>    
  </div>  
</div>

<div id="team-members">
<?php 
  $fed_team = get_field('federal_team');
  if($fed_team):
?>
    <div class="content grid-container">
      <h2>The Veteran Team</h2>
      <div class="grid-x grid-margin-x small-up-2 medium-up-4 large-up-5">
        <?php foreach( $fed_team as $post ): 
          // Setup this post for WP functions (variable must be named $post).
          setup_postdata($post); ?>
          <div class="cell">
            <div class="team-member-single" data-open="Modal-<?php print $post->ID;?>"><?php echo get_the_post_thumbnail( $post->ID, array(300,300) ); ?></div>
            <h5><?php the_title(); ?></h5> 
            <div class="reveal modal large" id="Modal-<?php print $post->ID;?>" data-reveal>
              <div class="content grid-container">
                <h2><?php the_title(); ?></h2>
                <h5><?php the_field('town'); ?> <b>&#183;</b> <?php the_field('affiliation'); ?></h5>
                <div class="grid-x grid-margin-x">
                  <div class="small-12 medium-4 cell">
                    <?php echo get_the_post_thumbnail( $post->ID, 'medium' ); ?>
                  </div>
                  <div class="small-12 medium-8 cell">
                    <?php the_content(); ?>
                  </div>
                </div>
              </div>
              <button class="close-button" data-close aria-label="Close modal" type="button">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
          </div>
        <?php endforeach; ?>   
      </div>  
    </div>
  <?php 
    endif; 
  ?>
  <?php wp_reset_postdata(); ?>
  <br><br>
  <?php 
    $vet_team = get_field('veteran_team');
    if($vet_team):
  ?>
    <div class="content grid-container">
      <h2>Team Honor</h2>
      <div class="grid-x grid-margin-x small-up-2 medium-up-4 large-up-5">
        <?php foreach( $vet_team as $post ): 
          // Setup this post for WP functions (variable must be named $post).
          setup_postdata($post); ?>
          <div class="cell">
            <div class="team-member-single" data-open="Modal-<?php print $post->ID;?>"><?php echo get_the_post_thumbnail( $post->ID, array(300,300) ); ?></div>
            <h5><?php the_title(); ?></h5> 
            <div class="reveal modal large" id="Modal-<?php print $post->ID;?>" data-reveal>
              <div class="content grid-container">
                <h2><?php the_title(); ?></h2>
                <h5><?php the_field('town'); ?> <b>&#183;</b> <?php the_field('affiliation'); ?></h5>
                <div class="grid-x grid-margin-x">
                  <div class="small-12 medium-4 cell">
                    <?php echo get_the_post_thumbnail( $post->ID, 'medium' ); ?>
                  </div>
                  <div class="small-12 medium-8 cell">
                    <?php the_content(); ?>
                  </div>
                </div>
              </div>
              <button class="close-button" data-close aria-label="Close modal" type="button">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
          </div>
        <?php endforeach; ?>          
      </div>  
    </div>

  <?php 
    endif; 
  ?>
</div>
<?php wp_reset_postdata(); ?>
<div id="sponsors">
  <div class="content grid-container">
    <div class="grid-x grid-margin-x grid-padding-x">
      <div class="small-12 medium-12 cell">
        <h2>Sponsors</h2>
        <?php print get_field('sponsorship_packages'); ?>
      </div>  
    </div>  
  </div>
</div> 

<div id="contact">
  <div class="content grid-container">
    <div class="grid-x grid-margin-x grid-padding-x">
      <div class="small-12 medium-12 cell">
        <?php print get_field('contact'); ?>
      </div>         
    </div>  
  </div>
</div> 

<?php get_footer(); ?>