/*
These functions make sure WordPress
and Foundation play nice together.
*/

jQuery(document).ready(function($) {
	
	// Remove empty P tags created by WP inside of Accordion and Orbit
	jQuery('.accordion p:empty, .orbit p:empty').remove();

	// Adds Flex Video to YouTube and Vimeo Embeds
	jQuery('iframe[src*="youtube.com"], iframe[src*="vimeo.com"]').each(function() {
		if ( jQuery(this).innerWidth() / jQuery(this).innerHeight() > 1.5 ) {
		  jQuery(this).wrap("<div class='widescreen responsive-embed'/>");
		} else {
		  jQuery(this).wrap("<div class='responsive-embed'/>");
		}
	});

  function viewport_height() {
    var window_height = $(window).height();
    $('#hero-section').height(window_height);
  }

  viewport_height();

  $(window).resize(function() {
    viewport_height();
  });

  var scroll_pos = 0;
  $(document).scroll(function() {
      scroll_pos = $(this).scrollTop();
      if(scroll_pos > 200) {
        $('#location-heading .location').addClass('active');
        $('#clock').addClass('active');
      } else {
        $('#location-heading .location').removeClass('active');
        $('#clock').removeClass('active');
      }
  });

  $('#top-bar-menu').on('click', 'a[href^="#"]', function (event) {
    event.preventDefault();
    $('html, body').animate({
        scrollTop: $($.attr(this, 'href')).offset().top-70
    }, 700);
  });

  var icon = document.querySelector("header .menu_icon");
  icon.addEventListener("click", function () {
    icon.classList.toggle('clicked');
    $('#mobile-menu').toggleClass('active');
  });

  $(window).scroll(function() {
    if ($(this).scrollTop() > 145) {
      $('#back-to-top').addClass('active');
    } else {
      $('#back-to-top').removeClass('active');
    }
  });

  $('#back-to-top').click(function() {
    $('html, body').animate({
        scrollTop: $('header').offset().top
    }, 1200);
  });

  $('#scroll-down').click(function() {
    $('html, body').animate({
        scrollTop: $('#mission').offset().top-72
    }, 1200);
  });  

}); 